/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.jdesktop.layout.GroupLayout;

public class Interface
extends JFrame {
    private Object lightPointer;
    Highlighter.HighlightPainter painter = new MyHighlightPainter(Color.YELLOW);
    private JButton btnClose;
    private JButton btnFind;
    private JButton btnPrevious;
    private JDialog dialogAbout;
    private JDialog dialogHelp;
    private JEditorPane jEditorPane1;
    private JEditorPane jEditorPane2;
    private JEditorPane jEditorPane3;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JMenuItem menuAbout;
    private JCheckBoxMenuItem menuBrace;
    private JCheckBoxMenuItem menuBracket;
    private JCheckBoxMenuItem menuCaret;
    private JMenu menuCollapse;
    private JMenuItem menuCopy;
    private JMenuItem menuCut;
    private JMenu menuEdit;
    private JMenuItem menuExit;
    private JMenu menuExpand;
    private JMenu menuFile;
    private JMenuItem menuFind;
    private JMenu menuFormat;
    private JMenu menuHelp;
    private JCheckBoxMenuItem menuHighlightBrace;
    private JCheckBoxMenuItem menuHighlightBracket;
    private JCheckBoxMenuItem menuHighlightCaret;
    private JCheckBoxMenuItem menuHighlightParen;
    private JMenuItem menuItemHelp;
    private JMenu menuLock;
    private JMenuItem menuOpen;
    private JCheckBoxMenuItem menuParen;
    private JMenuItem menuPaste;
    private JMenuItem menuSave;
    private JMenuItem menuSaveAs;
    private JMenu menuSpacer;
    private JMenu menuSpacer2;
    private JPopupMenu pMenu;
    private JMenuItem pMenuCopy;
    private JMenuItem pMenuCut;
    private JMenuItem pMenuPaste;
    private JToolBar status;
    private JTextArea text;
    private JTextField txtFind;

    public Interface() {
        this.initComponents();
        this.status.setVisible(false);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.pMenu = new JPopupMenu();
        this.pMenuCut = new JMenuItem();
        this.pMenuCopy = new JMenuItem();
        this.pMenuPaste = new JMenuItem();
        this.dialogAbout = new JDialog();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane2 = new JEditorPane();
        this.jScrollPane3 = new JScrollPane();
        this.jEditorPane3 = new JEditorPane();
        this.dialogHelp = new JDialog();
        this.jScrollPane4 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.jScrollPane1 = new JScrollPane();
        this.text = new JTextArea();
        this.status = new JToolBar();
        this.btnClose = new JButton();
        this.jLabel1 = new JLabel();
        this.txtFind = new JTextField();
        this.jLabel2 = new JLabel();
        this.btnFind = new JButton();
        this.jLabel3 = new JLabel();
        this.btnPrevious = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuOpen = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuSave = new JMenuItem();
        this.menuSaveAs = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuExit = new JMenuItem();
        this.menuEdit = new JMenu();
        this.menuCut = new JMenuItem();
        this.menuCopy = new JMenuItem();
        this.menuPaste = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.menuFind = new JMenuItem();
        this.menuFormat = new JMenu();
        this.menuParen = new JCheckBoxMenuItem();
        this.menuBrace = new JCheckBoxMenuItem();
        this.menuBracket = new JCheckBoxMenuItem();
        this.menuCaret = new JCheckBoxMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuHighlightParen = new JCheckBoxMenuItem();
        this.menuHighlightBrace = new JCheckBoxMenuItem();
        this.menuHighlightBracket = new JCheckBoxMenuItem();
        this.menuHighlightCaret = new JCheckBoxMenuItem();
        this.menuHelp = new JMenu();
        this.menuItemHelp = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.menuAbout = new JMenuItem();
        this.menuSpacer = new JMenu();
        this.menuExpand = new JMenu();
        this.menuCollapse = new JMenu();
        this.menuSpacer2 = new JMenu();
        this.menuLock = new JMenu();
        this.pMenuCut.setText("Cut");
        this.pMenuCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.pMenuCutActionPerformed(evt);
            }
        });
        this.pMenu.add(this.pMenuCut);
        this.pMenuCopy.setText("Copy");
        this.pMenuCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.pMenuCopyActionPerformed(evt);
            }
        });
        this.pMenu.add(this.pMenuCopy);
        this.pMenuPaste.setText("Paste");
        this.pMenuPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.pMenuPasteActionPerformed(evt);
            }
        });
        this.pMenu.add(this.pMenuPaste);
        this.dialogAbout.setTitle("About");
        this.dialogAbout.setMinimumSize(new Dimension(300, 280));
        this.jEditorPane2.setContentType("text/html");
        this.jEditorPane2.setEditable(false);
        this.jEditorPane2.setText("<html>\n  <head>\n\n  </head>\n  <body>\n  <center>\n    <p style=\"margin-top: 0\">\n      Newick Editor v1.0<br>\n      by<br>\n      Paul Nadler - <a href=\"mailto:paulnadler@gmail.com\">paulnadler@gmail.com</a>\n    </p>\n<p>\n\n</p>\n    </center>\n  </body>\n</html>\n");
        this.jEditorPane2.setOpaque(false);
        this.jScrollPane2.setViewportView(this.jEditorPane2);
        this.jEditorPane3.setContentType("text/html");
        this.jEditorPane3.setEditable(false);
        this.jEditorPane3.setText("<html>\n  <head>\n\n  </head>\n  <body>\n    <p style=\"margin-top: 0\">\n      Newick Editor is a basic text editor with some extra functionality to assist with editing parenthetical formated text.<br>\nIt allows you to expand structures to a tabed out human readable format.  It can also assist in editing by automatically highlighting groups within these structures.\n    </p>\n  </body>\n</html>\n");
        this.jEditorPane3.setOpaque(false);
        this.jScrollPane3.setViewportView(this.jEditorPane3);
        GroupLayout dialogAboutLayout = new GroupLayout(this.dialogAbout.getContentPane());
        this.dialogAbout.getContentPane().setLayout(dialogAboutLayout);
        dialogAboutLayout.setHorizontalGroup(dialogAboutLayout.createParallelGroup(1).add(2, dialogAboutLayout.createSequentialGroup().addContainerGap().add(dialogAboutLayout.createParallelGroup(2).add(1, this.jScrollPane3, -1, 315, Short.MAX_VALUE).add(1, this.jScrollPane2, -1, 315, Short.MAX_VALUE)).addContainerGap()));
        dialogAboutLayout.setVerticalGroup(dialogAboutLayout.createParallelGroup(1).add(dialogAboutLayout.createSequentialGroup().addContainerGap().add(this.jScrollPane2, -2, -1, -2).addPreferredGap(0).add(this.jScrollPane3, -1, 184, Short.MAX_VALUE).addContainerGap()));
        this.dialogHelp.setTitle("Help");
        this.jEditorPane1.setContentType("text/html");
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setText("<html>\n  <head>\n\n  </head>\n  <body>\n<center>\n    <p style=\"margin-top: 0\">\nUsing the Newick Editor\n    </p>\n</center>\n<p>\nTo expand parenthetical nested structures into a multi-line display, click on the expand text on the menu bar.  Everything in the editor will be expanded.  Clicking on collapse will revert all the text in the editor back to a single line format.\n</p>\n<p>\nMoving the cursor to a character that indicates a group will cause that group to be highlighted.  If you wish to keep a group highlighted while working, you can toggle the highlighter lock by clicking on the highlighter text on the menu.\n</p>\n<p>\nYou can specify which characters will be expanded on, and also which characters will trigger the highlighter, by checking/unchecking the corresponding character in the format menu.\n</p>\n  </body>\n</html>\n");
        this.jEditorPane1.setOpaque(false);
        this.jScrollPane4.setViewportView(this.jEditorPane1);
        GroupLayout dialogHelpLayout = new GroupLayout(this.dialogHelp.getContentPane());
        this.dialogHelp.getContentPane().setLayout(dialogHelpLayout);
        dialogHelpLayout.setHorizontalGroup(dialogHelpLayout.createParallelGroup(1).add(this.jScrollPane4, -1, 448, Short.MAX_VALUE));
        dialogHelpLayout.setVerticalGroup(dialogHelpLayout.createParallelGroup(1).add(this.jScrollPane4, -1, 276, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setTitle("Newick Editor");
        this.text.setColumns(20);
        this.text.setRows(5);
        this.text.setTabSize(1);
        this.text.setComponentPopupMenu(this.pMenu);
        this.text.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                Interface.this.textCaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.text);
        this.status.setFloatable(false);
        this.btnClose.setText("Close");
        this.btnClose.setFocusable(false);
        this.btnClose.setHorizontalTextPosition(0);
        this.btnClose.setVerticalTextPosition(3);
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.btnCloseActionPerformed(evt);
            }
        });
        this.status.add(this.btnClose);
        this.jLabel1.setText("   Find: ");
        this.status.add(this.jLabel1);
        this.txtFind.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                Interface.this.txtFindKeyTyped(evt);
            }
        });
        this.status.add(this.txtFind);
        this.jLabel2.setText("   ");
        this.status.add(this.jLabel2);
        this.btnFind.setText("Next");
        this.btnFind.setFocusable(false);
        this.btnFind.setHorizontalTextPosition(0);
        this.btnFind.setVerticalTextPosition(3);
        this.btnFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.btnFindActionPerformed(evt);
            }
        });
        this.status.add(this.btnFind);
        this.jLabel3.setText(" ");
        this.status.add(this.jLabel3);
        this.btnPrevious.setText("Previous");
        this.btnPrevious.setFocusable(false);
        this.btnPrevious.setHorizontalTextPosition(0);
        this.btnPrevious.setVerticalTextPosition(3);
        this.btnPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.btnPreviousActionPerformed(evt);
            }
        });
        this.status.add(this.btnPrevious);
        this.menuFile.setText("File");
        this.menuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuOpen.setText("Open");
        this.menuOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuOpen);
        this.menuFile.add(this.jSeparator1);
        this.menuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuSave.setText("Save");
        this.menuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuSaveActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuSave);
        this.menuSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.menuSaveAs.setText("Save As...");
        this.menuSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuSaveAsActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuSaveAs);
        this.menuFile.add(this.jSeparator2);
        this.menuExit.setText("Exit");
        this.menuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuExitActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuExit);
        this.jMenuBar1.add(this.menuFile);
        this.menuEdit.setText("Edit");
        this.menuCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.menuCut.setText("Cut");
        this.menuCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuCutActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.menuCut);
        this.menuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.menuCopy.setText("Copy");
        this.menuCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuCopyActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.menuCopy);
        this.menuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.menuPaste.setText("Paste");
        this.menuPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuPasteActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.menuPaste);
        this.menuEdit.add(this.jSeparator4);
        this.menuFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.menuFind.setText("Find");
        this.menuFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuFindActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.menuFind);
        this.jMenuBar1.add(this.menuEdit);
        this.menuFormat.setText("Format");
        this.menuParen.setSelected(true);
        this.menuParen.setText("Expand ( )");
        this.menuFormat.add(this.menuParen);
        this.menuBrace.setText("Expand { }");
        this.menuFormat.add(this.menuBrace);
        this.menuBracket.setText("Expand [ ]");
        this.menuFormat.add(this.menuBracket);
        this.menuCaret.setText("Expand <>");
        this.menuFormat.add(this.menuCaret);
        this.menuFormat.add(this.jSeparator3);
        this.menuHighlightParen.setSelected(true);
        this.menuHighlightParen.setText("Highlight ( )");
        this.menuFormat.add(this.menuHighlightParen);
        this.menuHighlightBrace.setSelected(true);
        this.menuHighlightBrace.setText("Highlight { }");
        this.menuFormat.add(this.menuHighlightBrace);
        this.menuHighlightBracket.setText("Highlight [ ]");
        this.menuFormat.add(this.menuHighlightBracket);
        this.menuHighlightCaret.setText("Highlight <>");
        this.menuFormat.add(this.menuHighlightCaret);
        this.jMenuBar1.add(this.menuFormat);
        this.menuHelp.setText("Help");
        this.menuItemHelp.setText("Help");
        this.menuItemHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuItemHelpActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuItemHelp);
        this.menuHelp.add(this.jSeparator5);
        this.menuAbout.setText("About");
        this.menuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuAbout);
        this.jMenuBar1.add(this.menuHelp);
        this.menuSpacer.setText("|");
        this.menuSpacer.setEnabled(false);
        this.jMenuBar1.add(this.menuSpacer);
        this.menuExpand.setText("Expand");
        this.menuExpand.setEnabled(false);
        this.menuExpand.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Interface.this.menuExpandMouseClicked(evt);
            }
        });
        this.jMenuBar1.add(this.menuExpand);
        this.menuCollapse.setText("Collapse");
        this.menuCollapse.setEnabled(false);
        this.menuCollapse.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Interface.this.menuCollapseMouseClicked(evt);
            }
        });
        this.jMenuBar1.add(this.menuCollapse);
        this.menuSpacer2.setText("|");
        this.menuSpacer2.setEnabled(false);
        this.jMenuBar1.add(this.menuSpacer2);
        this.menuLock.setText("Highlighter Unlocked");
        this.menuLock.setEnabled(false);
        this.menuLock.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Interface.this.menuLockMouseClicked(evt);
            }
        });
        this.jMenuBar1.add(this.menuLock);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.status, -1, 686, Short.MAX_VALUE).add(2, this.jScrollPane1, -1, 686, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.jScrollPane1, -1, 496, Short.MAX_VALUE).addPreferredGap(0).add(this.status, -2, 25, -2)));
        this.pack();
    }

    private void menuOpenActionPerformed(ActionEvent evt) {
        this.jFileChooser1.showOpenDialog(null);
        File inputFile = this.jFileChooser1.getSelectedFile();
        if (inputFile == null) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            this.text.setText("");
            String line = br.readLine();
            while (line != null) {
                this.text.append(line + System.getProperty("line.separator"));
                line = br.readLine();
            }
            br.close();
            this.text.setCaretPosition(0);
        }
        catch (IOException ex) {
            this.displayError("Error loading file");
        }
    }

    private void menuExpandMouseClicked(MouseEvent evt) {
        String expanded = this.expand(this.text.getText());
        if (expanded != null) {
            this.text.setText(expanded);
        }
        this.text.setCaretPosition(0);
    }

    private void menuCollapseMouseClicked(MouseEvent evt) {
        String collapsed = this.collapse(this.text.getText());
        if (collapsed != null) {
            this.text.setText(collapsed);
        }
        this.text.setCaretPosition(0);
    }

    private void menuSaveAsActionPerformed(ActionEvent evt) {
        this.jFileChooser1.showSaveDialog(null);
        File outputFile = this.jFileChooser1.getSelectedFile();
        if (outputFile == null) {
            return;
        }
        this.saveFile(outputFile);
    }

    private void menuExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void menuLockMouseClicked(MouseEvent evt) {
        if (this.menuLock.getText().equals("Highlighter Locked")) {
            this.menuLock.setText("Highlighter Unlocked");
        } else {
            this.menuLock.setText("Highlighter Locked");
        }
    }

    private void textCaretUpdate(CaretEvent evt) {
        this.highlight();
    }

    private void btnFindActionPerformed(ActionEvent evt) {
        this.find();
    }

    private void find() {
        this.text.requestFocusInWindow();
        this.txtFind.requestFocusInWindow();
        int position = this.text.getText().indexOf(this.txtFind.getText(), this.text.getCaretPosition());
        if (position < 0) {
            position = this.text.getText().indexOf(this.txtFind.getText());
        }
        if (position < 0) {
            this.displayError("Cannot Find: " + this.txtFind.getText());
            return;
        }
        this.text.setCaretPosition(position);
        this.text.moveCaretPosition(position + this.txtFind.getText().length());
    }

    private void menuFindActionPerformed(ActionEvent evt) {
        this.status.setVisible(true);
        this.txtFind.requestFocusInWindow();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.status.setVisible(false);
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        this.text.requestFocusInWindow();
        this.txtFind.requestFocusInWindow();
        int position = this.text.getText().lastIndexOf(this.txtFind.getText(), this.text.getCaretPosition() - 2);
        if (position < 0) {
            position = this.text.getText().lastIndexOf(this.txtFind.getText(), this.text.getText().length());
        }
        if (position < 0) {
            this.displayError("Cannot Find: " + this.txtFind.getText());
            return;
        }
        this.text.setCaretPosition(position);
        this.text.moveCaretPosition(position + this.txtFind.getText().length());
    }

    private void txtFindKeyTyped(KeyEvent evt) {
        if (evt.toString().indexOf("keyChar=Enter") >= 0) {
            this.find();
        }
    }

    private void menuCutActionPerformed(ActionEvent evt) {
        this.text.cut();
    }

    private void menuCopyActionPerformed(ActionEvent evt) {
        this.text.copy();
    }

    private void menuPasteActionPerformed(ActionEvent evt) {
        this.text.paste();
    }

    private void pMenuCutActionPerformed(ActionEvent evt) {
        this.text.cut();
    }

    private void pMenuCopyActionPerformed(ActionEvent evt) {
        this.text.copy();
    }

    private void pMenuPasteActionPerformed(ActionEvent evt) {
        this.text.paste();
    }

    private void menuItemHelpActionPerformed(ActionEvent evt) {
        this.dialogHelp.setVisible(true);
        this.dialogHelp.setSize(500, 320);
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        this.dialogAbout.setVisible(true);
        this.dialogAbout.setSize(300, 320);
    }

    private void menuSaveActionPerformed(ActionEvent evt) {
        if (this.jFileChooser1.getSelectedFile() != null) {
            this.saveFile(this.jFileChooser1.getSelectedFile());
        } else {
            this.jFileChooser1.showSaveDialog(null);
            File outputFile = this.jFileChooser1.getSelectedFile();
            if (outputFile == null) {
                return;
            }
            this.saveFile(outputFile);
        }
    }

    private void saveFile(File outputFile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            bw.write(this.text.getText());
            bw.close();
        }
        catch (IOException ex) {
            this.displayError("Error saveing file");
        }
    }

    private void highlight() {
        int position;
        if (this.menuLock.getText().equals("Highlighter Locked")) {
            return;
        }
        Highlighter light = this.text.getHighlighter();
        if (this.lightPointer != null) {
            light.removeHighlight(this.lightPointer);
        }
        if ((position = this.getSelectedPosition()) == -1) {
            return;
        }
        char symbol = this.text.getText().charAt(position);
        try {
            if (this.isOpenSymbol(symbol) && this.isSetHighlight(symbol)) {
                int start = this.getClose(this.text.getText(), position, symbol) + 1;
                this.lightPointer = light.addHighlight(position, start, this.painter);
            } else if (this.isCloseSymbol(symbol) && this.isSetHighlight(symbol)) {
                int start = this.getOpen(this.text.getText(), position, symbol);
                this.lightPointer = light.addHighlight(start, position + 1, this.painter);
            }
        }
        catch (BadLocationException e) {
            this.displayError("Error highlighting");
        }
    }

    private String expand(String input) {
        StringBuilder output = new StringBuilder();
        int tabs = 0;
        for (int i = 0; i < input.length(); ++i) {
            int t;
            char symbol = input.charAt(i);
            if (this.isOpenSymbol(symbol) && this.isSetExpand(symbol)) {
                output.append(System.getProperty("line.separator"));
                for (t = 0; t < tabs; ++t) {
                    output.append(' ');
                }
                output.append(symbol);
                ++tabs;
                if (!this.isOpenSymbol(input.charAt(i + 1)) && !this.isSetExpand(input.charAt(i + 1))) {
                    output.append(System.getProperty("line.separator"));
                    for (t = 0; t < tabs; ++t) {
                        output.append(' ');
                    }
                }
            } else if (this.isCloseSymbol(symbol) && this.isSetExpand(symbol)) {
                output.append(System.getProperty("line.separator"));
                --tabs;
                for (t = 0; t < tabs; ++t) {
                    output.append(' ');
                }
                output.append(symbol);
                output.append(System.getProperty("line.separator"));
                for (t = 0; t < tabs; ++t) {
                    output.append(' ');
                }
            } else {
                output.append(symbol);
            }
            if (tabs >= 0) continue;
            this.displayError("Missing open paren somewhere, good luck!");
            return null;
        }
        if (tabs > 0) {
            this.displayError("Missing close paren somewhere, good luck!");
            return null;
        }
        return output.toString();
    }

    private String collapse(String input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == ' ' || input.substring(i, i + 1).equals(System.getProperty("line.separator"))) {
                if (output.length() > 0 && this.isSetExpand(output.charAt(output.length() - 1)) || this.isSetExpand(this.getNextSymbol(input, i))) continue;
                output.append(input.charAt(i));
                continue;
            }
            output.append(input.charAt(i));
        }
        return output.toString();
    }

    private char getNextSymbol(String input, int position) {
        for (int i = position + 1; i < input.length(); ++i) {
            if (input.substring(i, i + 1).trim().length() <= 0) continue;
            return input.charAt(i);
        }
        return ' ';
    }

    private void displayError(String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, "Dialog", 0);
    }

    private int getSelectedPosition() {
        int caret = this.text.getCaretPosition();
        if (caret >= this.text.getText().length()) {
            return -1;
        }
        char symbol = this.text.getText().charAt(caret);
        if (caret > 0 && caret < this.text.getText().length()) {
            char pSymbol = this.text.getText().charAt(caret - 1);
            if (this.isGroupSymbol(symbol) && this.isSetHighlight(symbol)) {
                return caret;
            }
            if (this.isGroupSymbol(pSymbol) && this.isSetHighlight(pSymbol)) {
                return caret - 1;
            }
            return -1;
        }
        if (caret > 0) {
            char pSymbol = this.text.getText().charAt(caret - 1);
            if (this.isGroupSymbol(pSymbol) && this.isSetHighlight(pSymbol)) {
                return caret - 1;
            }
            return -1;
        }
        if (caret < this.text.getText().length() && this.isGroupSymbol(symbol) && this.isSetHighlight(symbol)) {
            return caret;
        }
        return -1;
    }

    private boolean isSetExpand(char symbol) {
        if ((symbol == '(' || symbol == ')') && this.menuParen.isSelected()) {
            return true;
        }
        if ((symbol == '{' || symbol == '}') && this.menuBrace.isSelected()) {
            return true;
        }
        if ((symbol == '[' || symbol == ']') && this.menuBracket.isSelected()) {
            return true;
        }
        return (symbol == '<' || symbol == '>') && this.menuCaret.isSelected();
    }

    private boolean isSetHighlight(char symbol) {
        if ((symbol == '(' || symbol == ')') && this.menuHighlightParen.isSelected()) {
            return true;
        }
        if ((symbol == '{' || symbol == '}') && this.menuHighlightBrace.isSelected()) {
            return true;
        }
        if ((symbol == '[' || symbol == ']') && this.menuHighlightBracket.isSelected()) {
            return true;
        }
        return (symbol == '<' || symbol == '>') && this.menuHighlightCaret.isSelected();
    }

    private boolean isGroupSymbol(char symbol) {
        return this.isOpenSymbol(symbol) || this.isCloseSymbol(symbol);
    }

    private boolean isOpenSymbol(char symbol) {
        return symbol == '(' || symbol == '{' || symbol == '[' || symbol == '<';
    }

    private boolean isCloseSymbol(char symbol) {
        return symbol == ')' || symbol == '}' || symbol == ']' || symbol == '>';
    }

    private int getClose(String input, int open, char symbol) {
        int position = open;
        int match = 1;
        while (match != 0) {
            if (input.charAt(++position) == symbol) {
                ++match;
            }
            if (input.charAt(position) != this.getOposite(symbol)) continue;
            --match;
        }
        return position;
    }

    private int getOpen(String input, int close, char symbol) {
        int position = close;
        int match = 1;
        while (match != 0) {
            if (input.charAt(--position) == symbol) {
                ++match;
            }
            if (input.charAt(position) != this.getOposite(symbol)) continue;
            --match;
        }
        return position;
    }

    private char getOposite(char symbol) {
        if (symbol == '(') {
            return ')';
        }
        if (symbol == ')') {
            return '(';
        }
        if (symbol == '{') {
            return '}';
        }
        if (symbol == '}') {
            return '{';
        }
        if (symbol == '[') {
            return ']';
        }
        if (symbol == ']') {
            return '[';
        }
        if (symbol == '<') {
            return '>';
        }
        if (symbol == '>') {
            return '<';
        }
        return '\u0000';
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Interface().setVisible(true);
            }
        });
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

