/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdesktop.layout.GroupLayout;

public class Interface
extends JFrame {
    private File inputFile;
    private TreeManager tm;
    private JDialog dialogAbout;
    private JDialog dialogHelp;
    private JEditorPane jEditorPane1;
    private JEditorPane jEditorPane2;
    private JEditorPane jEditorPane3;
    private JFileChooser jFileChooser1;
    private JMenuItem jMenuItem1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JMenuItem menuAbout;
    private JMenuBar menuBar;
    private JCheckBoxMenuItem menuDataView;
    private JMenuItem menuExit;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenuItem menuItemHelp;
    private JMenuItem menuLoad;
    private JMenuItem menuSave;
    private JCheckBoxMenuItem menuSavePreview;
    private JMenu menuStates;
    private JCheckBoxMenuItem menuTreeView;
    private JMenu menuView;
    private JPanel panelTrees;
    private JPanel panelView;
    private JScrollPane scrollTextView;
    private JScrollPane scrollTreeView;
    private JScrollPane scrollTrees;
    private JTextArea textView;
    private JTree treeList;
    private JTree treeView;

    public Interface() {
        this.initComponents();
        this.treeList = new JTree(new DefaultMutableTreeNode("No Trees Loaded"));
        this.scrollTrees.setViewportView(this.treeList);
        this.treeView = new JTree(new DefaultMutableTreeNode("No Tree Loaded"));
        this.scrollTreeView.setViewportView(this.treeView);
        this.scrollTreeView.setVisible(false);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.dialogAbout = new JDialog();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane2 = new JEditorPane();
        this.jScrollPane3 = new JScrollPane();
        this.jEditorPane3 = new JEditorPane();
        this.dialogHelp = new JDialog();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.panelTrees = new JPanel();
        this.scrollTrees = new JScrollPane();
        this.treeList = new JTree();
        this.panelView = new JPanel();
        this.scrollTreeView = new JScrollPane();
        this.treeView = new JTree();
        this.scrollTextView = new JScrollPane();
        this.textView = new JTextArea();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuLoad = new JMenuItem();
        this.menuSave = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuExit = new JMenuItem();
        this.menuView = new JMenu();
        this.menuTreeView = new JCheckBoxMenuItem();
        this.menuDataView = new JCheckBoxMenuItem();
        this.menuSavePreview = new JCheckBoxMenuItem();
        this.menuStates = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuItemHelp = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuAbout = new JMenuItem();
        this.dialogAbout.setTitle("About");
        this.jEditorPane2.setContentType("text/html");
        this.jEditorPane2.setEditable(false);
        this.jEditorPane2.setText("<html>\n  <head>\n\n  </head>\n  <body>\n  <center>\n    <p style=\"margin-top: 0\">\n      TreeDwe v1.1<br>\n      by<br>\n      <a href=\"mailto:paulnadler@gmail.com\">Paul Nadler</a> & \n      <a href=\"mailto:jonathan.eastman@gmail.com\">Jonathan Eastman</a>\n    </p>\n<p>\n\n</p>\n    </center>\n  </body>\n</html>\n");
        this.jEditorPane2.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jEditorPane2);
        this.jEditorPane3.setContentType("text/html");
        this.jEditorPane3.setEditable(false);
        this.jEditorPane3.setText("<html>\n  <head>\n\n  </head>\n  <body>\n    <p style=\"margin-top: 0\">\n      TreDwe can compute character 'dwell times' - root-to-tip lengths of assocation with a particular character state, assessed for every lineage leading to each tip in a collection of trees. \n    </p>\n  </body>\n</html>\n");
        this.jEditorPane3.setOpaque(false);
        this.jEditorPane3.setPreferredSize(new Dimension(315, 135));
        this.jScrollPane3.setViewportView(this.jEditorPane3);
        GroupLayout dialogAboutLayout = new GroupLayout(this.dialogAbout.getContentPane());
        this.dialogAbout.getContentPane().setLayout(dialogAboutLayout);
        dialogAboutLayout.setHorizontalGroup(dialogAboutLayout.createParallelGroup(1).add(dialogAboutLayout.createSequentialGroup().addContainerGap().add(dialogAboutLayout.createParallelGroup(1).add(this.jScrollPane3, -1, 377, Short.MAX_VALUE).add(this.jScrollPane1, -1, 377, Short.MAX_VALUE)).addContainerGap()));
        dialogAboutLayout.setVerticalGroup(dialogAboutLayout.createParallelGroup(1).add(2, dialogAboutLayout.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -2, 68, -2).add(7, 7, 7).add(this.jScrollPane3, -1, 148, Short.MAX_VALUE).addContainerGap()));
        this.dialogHelp.setTitle("Help");
        this.dialogHelp.setMinimumSize(new Dimension(400, 140));
        this.dialogHelp.setResizable(false);
        this.jEditorPane1.setContentType("text/html");
        this.jEditorPane1.setText("<html>\n  <head>\n  </head>\n  <body>\n<h3>Using TreeDwe from the command line:</h3>\n\nUsage: java -jar TreeDwe [parameters]<br>\n<br>\nRequired parameters:<br>\n-s State to output for (0,1,2,etc...)<br>\n-i Input file name<br>\n<br>\nOptional parameters:<br>\n-o Output file name<br>\n-h Display help screen<br>\n<br>\n\n<h3>\nContact:\n</h3>\n\nPaul Nadler - <a href=\"mailto:paulnadler@gmail.com\">paulnadler@gmail.com</a><br>\nJonathan Eastman - <a href=\"mailto:\">jonathan.eastman@gmail.com</a><br>\n  </body>\n</html>\n");
        this.jEditorPane1.setMinimumSize(new Dimension(400, 140));
        this.jEditorPane1.setOpaque(false);
        this.jScrollPane2.setViewportView(this.jEditorPane1);
        GroupLayout dialogHelpLayout = new GroupLayout(this.dialogHelp.getContentPane());
        this.dialogHelp.getContentPane().setLayout(dialogHelpLayout);
        dialogHelpLayout.setHorizontalGroup(dialogHelpLayout.createParallelGroup(1).add(dialogHelpLayout.createSequentialGroup().addContainerGap().add(this.jScrollPane2, -1, 510, Short.MAX_VALUE).addContainerGap()));
        dialogHelpLayout.setVerticalGroup(dialogHelpLayout.createParallelGroup(1).add(2, dialogHelpLayout.createSequentialGroup().addContainerGap().add(this.jScrollPane2, -1, 371, Short.MAX_VALUE).addContainerGap()));
        this.setDefaultCloseOperation(3);
        this.setTitle("TreeDwe");
        this.panelTrees.setBorder(BorderFactory.createTitledBorder("Trees"));
        this.treeList.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                Interface.this.treeListValueChanged(evt);
            }
        });
        this.scrollTrees.setViewportView(this.treeList);
        GroupLayout panelTreesLayout = new GroupLayout(this.panelTrees);
        this.panelTrees.setLayout(panelTreesLayout);
        panelTreesLayout.setHorizontalGroup(panelTreesLayout.createParallelGroup(1).add(this.scrollTrees, -1, 193, Short.MAX_VALUE));
        panelTreesLayout.setVerticalGroup(panelTreesLayout.createParallelGroup(1).add(this.scrollTrees, -1, 360, Short.MAX_VALUE));
        this.panelView.setBorder(BorderFactory.createTitledBorder("View"));
        this.scrollTreeView.setViewportView(this.treeView);
        this.textView.setColumns(20);
        this.textView.setEditable(false);
        this.textView.setRows(5);
        this.textView.setTabSize(10);
        this.scrollTextView.setViewportView(this.textView);
        GroupLayout panelViewLayout = new GroupLayout(this.panelView);
        this.panelView.setLayout(panelViewLayout);
        panelViewLayout.setHorizontalGroup(panelViewLayout.createParallelGroup(1).add(this.scrollTreeView, -1, 479, Short.MAX_VALUE).add(this.scrollTextView, -1, 479, Short.MAX_VALUE));
        panelViewLayout.setVerticalGroup(panelViewLayout.createParallelGroup(1).add(panelViewLayout.createSequentialGroup().add(this.scrollTreeView, -1, 170, Short.MAX_VALUE).addPreferredGap(0).add(this.scrollTextView, -1, 184, Short.MAX_VALUE)));
        this.menuFile.setText("File");
        this.menuLoad.setText("Load File");
        this.menuLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuLoadActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuLoad);
        this.menuSave.setText("Save Dwell TIme");
        this.menuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuSaveActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuSave);
        this.menuFile.add(this.jSeparator1);
        this.menuExit.setText("Exit");
        this.menuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuExitActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuExit);
        this.menuBar.add(this.menuFile);
        this.menuView.setText("View");
        this.menuTreeView.setText("Tree View");
        this.menuTreeView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuTreeViewActionPerformed(evt);
            }
        });
        this.menuView.add(this.menuTreeView);
        this.menuDataView.setText("Data View");
        this.menuDataView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuDataViewActionPerformed(evt);
            }
        });
        this.menuView.add(this.menuDataView);
        this.menuSavePreview.setSelected(true);
        this.menuSavePreview.setText("Save Preview");
        this.menuSavePreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuSavePreviewActionPerformed(evt);
            }
        });
        this.menuView.add(this.menuSavePreview);
        this.menuBar.add(this.menuView);
        this.menuStates.setText("States");
        this.jMenuItem1.setText("No file loaded");
        this.jMenuItem1.setEnabled(false);
        this.menuStates.add(this.jMenuItem1);
        this.menuBar.add(this.menuStates);
        this.menuHelp.setText("Help");
        this.menuItemHelp.setText("Help");
        this.menuItemHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuItemHelpActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuItemHelp);
        this.menuHelp.add(this.jSeparator2);
        this.menuAbout.setText("About");
        this.menuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Interface.this.menuAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuAbout);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.panelTrees, -2, -1, -2).addPreferredGap(0).add(this.panelView, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.panelView, -1, -1, Short.MAX_VALUE).add(this.panelTrees, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void loadTreeList() {
        DefaultMutableTreeNode all = new DefaultMutableTreeNode("All Trees");
        for (String name : this.tm.getAllTreeNames()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
            all.add(node);
        }
        this.treeList = new JTree(all);
        this.treeList.getSelectionModel().setSelectionMode(1);
        this.scrollTrees.setViewportView(this.treeList);
        this.treeList.setSelectionRow(0);
        this.treeList.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                Interface.this.treeListValueChanged(evt);
            }
        });
    }

    private void loadSavePreview() {
        this.textView.setTabSize(8);
        this.textView.setText(this.tm.getDwellTimeOutput());
        this.textView.setCaretPosition(0);
    }

    private void loadDataView() {
        this.textView.setTabSize(3);
        Object node = this.treeList.getLastSelectedPathComponent();
        if (node == null || node.toString().equals("No Trees Loaded")) {
            return;
        }
        if (node.toString().equals("All Trees")) {
            this.textView.setText("Cannot display all trees in this view");
            return;
        }
        this.textView.setText(this.tm.getTreeData(node.toString()));
        this.textView.setCaretPosition(0);
    }

    private void loadTreeView() {
        Object selectedNode = this.treeList.getLastSelectedPathComponent();
        if (selectedNode == null || selectedNode.toString().equals("No Trees Loaded")) {
            return;
        }
        if (selectedNode.toString().equals("All Trees")) {
            this.treeView.setSelectionModel(null);
            return;
        }
        Node node = this.tm.getTreeRoot(selectedNode.toString());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        this.addChildreen(root, node);
        this.treeView = new JTree(root);
        this.scrollTreeView.setViewportView(this.treeView);
        this.treeView.setSelectionRow(0);
    }

    private void addChildreen(DefaultMutableTreeNode parent, Node parentNode) {
        if (parentNode.left != null) {
            DefaultMutableTreeNode left = new DefaultMutableTreeNode(parentNode.left.toString());
            parent.add(left);
            this.addChildreen(left, parentNode.left);
        }
        if (parentNode.right != null) {
            DefaultMutableTreeNode right = new DefaultMutableTreeNode(parentNode.right.toString());
            parent.add(right);
            this.addChildreen(right, parentNode.right);
        }
    }

    private void menuLoadActionPerformed(ActionEvent evt) {
        this.jFileChooser1.showOpenDialog(null);
        this.inputFile = this.jFileChooser1.getSelectedFile();
        if (this.inputFile == null) {
            return;
        }
        this.tm = new TreeManager();
        this.tm.loadTrees(Interface.loadFile(this.inputFile));
        this.loadStates();
        this.loadTreeList();
        this.treeList.setSelectionRow(0);
        this.loadSavePreview();
    }

    private void loadStates() {
        this.menuStates.removeAll();
        for (int i = 0; i < this.tm.getNumberOfStates(); ++i) {
            JCheckBoxMenuItem menuState = new JCheckBoxMenuItem();
            menuState.setText("State " + i);
            menuState.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Interface.this.menuStateActionPerformed(evt);
                }
            });
            this.menuStates.add(menuState);
        }
    }

    private void menuStateActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem menuState = (JCheckBoxMenuItem)evt.getSource();
        for (int i = 0; i < this.menuStates.getItemCount(); ++i) {
            if (menuState == this.menuStates.getItem(i)) {
                this.tm.setState(i, menuState.isSelected());
                continue;
            }
            this.tm.setState(i, false);
            this.menuStates.getItem(i).setSelected(false);
        }
        if (this.menuSavePreview.isSelected()) {
            this.loadSavePreview();
        }
    }

    private static String loadFile(File file) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder data = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                data.append(line.trim() + "\n");
                line = br.readLine();
            }
            br.close();
            return data.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void menuSaveActionPerformed(ActionEvent evt) {
        if (this.inputFile == null) {
            return;
        }
        this.menuSavePreviewActionPerformed(new ActionEvent(this, 0, null));
        File outputFile = new File(this.jFileChooser1.getSelectedFile().getAbsoluteFile() + ".xls");
        this.jFileChooser1.setSelectedFile(outputFile);
        this.jFileChooser1.showSaveDialog(null);
        outputFile = this.jFileChooser1.getSelectedFile();
        if (outputFile == null) {
            return;
        }
        Interface.saveFile(outputFile, this.textView.getText());
    }

    private static void saveFile(File file, String text) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(text);
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void menuSavePreviewActionPerformed(ActionEvent evt) {
        this.scrollTreeView.setVisible(false);
        this.scrollTextView.setVisible(true);
        this.panelView.updateUI();
        this.menuSavePreview.setSelected(true);
        this.menuDataView.setSelected(false);
        this.menuTreeView.setSelected(false);
        this.loadSavePreview();
    }

    private void menuDataViewActionPerformed(ActionEvent evt) {
        this.scrollTreeView.setVisible(false);
        this.scrollTextView.setVisible(true);
        this.panelView.updateUI();
        this.menuSavePreview.setSelected(false);
        this.menuDataView.setSelected(true);
        this.menuTreeView.setSelected(false);
        this.loadDataView();
    }

    private void menuTreeViewActionPerformed(ActionEvent evt) {
        this.scrollTextView.setVisible(false);
        this.scrollTreeView.setVisible(true);
        this.panelView.updateUI();
        this.menuSavePreview.setSelected(false);
        this.menuDataView.setSelected(false);
        this.menuTreeView.setSelected(true);
        this.loadTreeView();
    }

    private void treeListValueChanged(TreeSelectionEvent evt) {
        if (this.menuSavePreview.isSelected()) {
            this.loadSavePreview();
        } else if (this.menuDataView.isSelected()) {
            this.loadDataView();
        } else {
            this.loadTreeView();
        }
    }

    private void menuExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        this.dialogAbout.setVisible(true);
        this.dialogAbout.setSize(400, 300);
    }

    private void menuItemHelpActionPerformed(ActionEvent evt) {
        this.dialogHelp.setVisible(true);
        this.dialogHelp.setSize(400, 400);
    }

    public static void noGUI(String[] args) {
        Arguments a = new Arguments(args);
        if (a.hasOption("-h") || !a.hasValue("-s") || !a.hasValue("-i")) {
            Interface.displayUsage();
            return;
        }
        String state = a.getValue("-s");
        TreeManager tm = new TreeManager();
        String inFile = a.getValue("-i");
        String input = Interface.loadFile(new File(inFile));
        if (!tm.loadTrees(input)) {
            System.out.println("cannot load tree from file");
            return;
        }
        tm.setState(state, true);
        String output = tm.getDwellTimeOutput();
        String outFile = inFile;
        if (a.hasValue("-o")) {
            outFile = a.getValue("-o");
        }
        Interface.saveFile(new File(outFile + ".xls"), output);
    }

    private static void displayUsage() {
        System.out.println("Usage  : java -jar TreeDwe [parameters]");
        System.out.println("or GUI : java -jar TreeDwe");
        System.out.println();
        System.out.println("Required parameters:");
        System.out.println("-s State to output for (0,1,2,etc...)");
        System.out.println("-i Input file name");
        System.out.println();
        System.out.println("Optional parameters:");
        System.out.println("-o Output file name");
        System.out.println("-h Display this help screen");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Interface.noGUI(args);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Interface().setVisible(true);
            }
        });
    }
}

