/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree {
    private Node root;
    private HashMap<String, Species> speciesList;
    private int numberOfStates;
    private String treeName;

    public Tree(String tree, String species, int numberOfStates) {
        this.treeName = tree.substring(5, tree.indexOf("="));
        this.numberOfStates = numberOfStates;
        this.addSpecies(species);
        this.root = this.parse(tree.substring(tree.indexOf("(") + 1, tree.lastIndexOf(")")), null);
        this.calculateRootTipLengths();
    }

    private void addSpecies(String species) {
        String[] speciesList;
        this.speciesList = new HashMap();
        for (String s : speciesList = species.split(",")) {
            s = s.trim().replaceFirst("\\s", ",");
            s = s.replace(";", "");
            s = s.replaceAll("\\s", "");
            String[] specie = s.split(",");
            this.speciesList.put(specie[0].trim(), new Species(specie[1].trim(), specie[0].trim()));
        }
    }

    public String[] getAllRootTipLengths(int state) {
        String[] lengths = new String[this.speciesList.size()];
        for (int i = 0; i < this.speciesList.size(); ++i) {
            lengths[i] = "" + this.speciesList.get((Object)new StringBuilder().append((String)"").append((int)(i + 1)).toString()).rootTipLengths[state];
        }
        return lengths;
    }

    public Species getSpecies(String species) {
        if (Tree.isNumber(species.charAt(0))) {
            return this.speciesList.get(species);
        }
        for (Species s : this.speciesList.values()) {
            if (!s.name.equals(species)) continue;
            return s;
        }
        return null;
    }

    public HashMap<String, Species> getSpeciesList() {
        return this.speciesList;
    }

    public Node getRoot() {
        return this.root;
    }

    private void calculateRootTipLengths() {
        for (int i = 1; i < this.speciesList.size() + 1; ++i) {
            this.speciesList.get(Integer.toString(i)).calculateRootTipLengths();
        }
    }

    private Node parse(String branch, Node parent) {
        int i;
        Node node = new Node(parent, this.numberOfStates);
        String leftBranch = this.getNextBranch(branch, "");
        String rightBranch = this.getNextBranch(branch, leftBranch);
        String left = this.getThisBranch(leftBranch);
        String right = this.getThisBranch(rightBranch);
        if (left != null) {
            leftBranch = leftBranch.substring(1, this.getCloseParen(leftBranch, 0));
        }
        if (right != null) {
            rightBranch = rightBranch.substring(1, this.getCloseParen(rightBranch, 0));
        }
        if (leftBranch.indexOf("(") != -1 && rightBranch.indexOf("(") != -1) {
            node.left = this.parse(leftBranch, node);
            node.right = this.parse(rightBranch, node);
        } else if (leftBranch.indexOf("(") != -1) {
            node.left = this.parse(leftBranch, node);
            node.right = this.getChildreen(rightBranch, node);
        } else if (rightBranch.indexOf("(") != -1) {
            node.left = this.getChildreen(leftBranch, node);
            node.right = this.parse(rightBranch, node);
        } else {
            node.left = this.getChildreen(leftBranch, node);
            node.right = this.getChildreen(rightBranch, node);
        }
        if (left != null) {
            for (i = 0; i < this.numberOfStates; ++i) {
                int n = i;
                node.left.stateLengths[n] = (float)((double)node.left.stateLengths[n] + this.getState(left, i));
            }
        }
        if (right != null) {
            for (i = 0; i < this.numberOfStates; ++i) {
                int n = i;
                node.right.stateLengths[n] = (float)((double)node.right.stateLengths[n] + this.getState(right, i));
            }
        }
        return node;
    }

    private String getNextBranch(String branch, String previous) {
        if ((branch = branch.substring(branch.indexOf(previous) + previous.length())).startsWith(",")) {
            branch = branch.substring(1);
        }
        if (Tree.isNumber(branch.charAt(0)) && branch.indexOf("(") != -1) {
            return branch.substring(0, branch.indexOf("("));
        }
        if (Tree.isNumber(branch.charAt(0))) {
            return branch.substring(0);
        }
        int position = this.getCloseParen(branch, 0);
        if (position < branch.length() && branch.charAt(position + 1) == ':') {
            return branch.substring(0, branch.indexOf("}", position + 1) + 1);
        }
        return branch.substring(0, position + 1);
    }

    private String getThisBranch(String branch) {
        if (!branch.startsWith("(")) {
            return null;
        }
        int position = this.getCloseParen(branch, 0);
        return branch.substring(position + 2, branch.indexOf("}", position + 2) + 1);
    }

    private int getCloseParen(String input, int open) {
        int position = open;
        int match = 1;
        while (match != 0) {
            if (input.charAt(++position) == '(') {
                ++match;
            }
            if (input.charAt(position) != ')') continue;
            --match;
        }
        return position;
    }

    private Node getChildreen(String branch, Node parent) {
        if (branch.length() == 0) {
            return null;
        }
        if (branch.charAt(0) == ',') {
            branch = branch.substring(1);
        }
        if (branch.charAt(branch.length() - 1) == ',') {
            branch = branch.substring(0, branch.length() - 1);
        }
        Node node = new Node(parent, this.numberOfStates);
        int position = branch.indexOf("},") + 2;
        if (position > 1) {
            int i;
            node.left = new Node(node, this.numberOfStates);
            node.right = new Node(node, this.numberOfStates);
            node.left.species = this.getSpecies(branch.substring(0, position), node.left);
            node.right.species = this.getSpecies(branch.substring(position), node.right);
            for (i = 0; i < this.numberOfStates; ++i) {
                int n = i;
                node.left.stateLengths[n] = (float)((double)node.left.stateLengths[n] + this.getState(branch.substring(0, position), i));
            }
            for (i = 0; i < this.numberOfStates; ++i) {
                int n = i;
                node.right.stateLengths[n] = (float)((double)node.right.stateLengths[n] + this.getState(branch.substring(position), i));
            }
        } else {
            node.left = new Node(node, this.numberOfStates);
            node.left.species = this.getSpecies(branch, node.left);
            for (int i = 0; i < this.numberOfStates; ++i) {
                int n = i;
                node.left.stateLengths[n] = (float)((double)node.left.stateLengths[n] + this.getState(branch, i));
            }
        }
        return node;
    }

    private double getState(String branch, int num) {
        String state = Integer.toString(num);
        branch = branch.substring(branch.indexOf("{") + 1, branch.indexOf("}"));
        String[] lengths = branch.split(":");
        double length = 0.0;
        for (String s : lengths) {
            if (!s.startsWith(state)) continue;
            length += Double.parseDouble(s.substring(2));
        }
        return length;
    }

    private String getSpecies(String branch, Node node) {
        Species s = this.speciesList.get(branch.substring(0, branch.indexOf(":")));
        s.attachNode(node);
        return s.name;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public String toString() {
        return this.treeName;
    }
}

