/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;

public class TreeManager {
    private ArrayList<Tree> trees;
    private boolean[] selectedStates = new boolean[2];
    private int numberOfStates;

    public boolean loadTrees(String data) {
        this.trees = new ArrayList();
        this.numberOfStates = this.getNumberOfStates(data);
        String[] dataList = data.split("\n");
        String species = "";
        for (int index = 0; index < dataList.length; ++index) {
            if (dataList[index].equals("translate")) {
                while (!dataList[++index].startsWith("tree")) {
                    species = species + dataList[index];
                }
            }
            if (!dataList[index].startsWith("tree")) continue;
            this.trees.add(new Tree(dataList[index], species, this.numberOfStates));
        }
        if (this.trees.isEmpty()) {
            return false;
        }
        this.selectedStates = new boolean[2];
        return true;
    }

    private int getNumberOfStates(String data) {
        int number = 0;
        int start = 0;
        String set = this.getStateSet(data, start);
        while (set != null) {
            String[] lengths;
            for (String length : lengths = set.split(":")) {
                int state = Integer.parseInt(length.substring(0, length.indexOf(",")));
                if (state <= number) continue;
                number = state;
            }
            start = data.indexOf("}", start) + 1;
            set = this.getStateSet(data, start);
        }
        return number + 1;
    }

    public int getNumberOfStates() {
        return this.numberOfStates;
    }

    private String getStateSet(String data, int start) {
        if (data.indexOf("{", start) < 0) {
            return null;
        }
        if (data.indexOf("}", start) < 0) {
            System.out.println(data.substring(start));
        }
        return data.substring(data.indexOf("{", start) + 1, data.indexOf("}", start));
    }

    public String getDwellTimeOutput() {
        int i;
        if (this.trees.isEmpty()) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        HashMap<String, Species> speciesList = this.trees.get(0).getSpeciesList();
        char TAB = '\t';
        for (int i2 = 1; i2 < speciesList.size() + 1; ++i2) {
            output.append(TAB + speciesList.get((Object)Integer.toString((int)i2)).name);
        }
        output.append("\naverage");
        float[] averages = this.getAverages();
        for (i = 0; i < averages.length; ++i) {
            output.append(TAB + "" + averages[i]);
        }
        output.append("\nln");
        for (i = 0; i < averages.length; ++i) {
            output.append(TAB + "" + (float)Math.log(averages[i] + 1.0f));
        }
        output.append("\n\n");
        for (i = 0; i < this.trees.size(); ++i) {
            Tree tree = this.trees.get(i);
            if (!this.hasSelectedState()) {
                output.append("no state selected.\n");
                continue;
            }
            output.append(i);
            for (int j = 0; j < this.selectedStates.length; ++j) {
                if (!this.selectedStates[j]) continue;
                for (String length : tree.getAllRootTipLengths(j)) {
                    output.append(TAB + length);
                }
            }
            output.append("\n");
        }
        return output.toString();
    }

    private boolean hasSelectedState() {
        for (boolean state : this.selectedStates) {
            if (!state) continue;
            return true;
        }
        return false;
    }

    public String getTreeData(String treeName) {
        StringBuilder output = new StringBuilder();
        HashMap<String, Species> speciesList = this.getTree(treeName).getSpeciesList();
        char tab = '\t';
        String dTab = tab + "" + tab;
        for (int i = 1; i < speciesList.size() + 1; ++i) {
            int state;
            Species s = speciesList.get(Integer.toString(i));
            output.append(s.name + "\n");
            output.append(tab + "State Lengths:\n");
            for (state = 0; state < s.node.stateLengths.length; ++state) {
                output.append(dTab + "State " + state + ": " + s.node.stateLengths[state] + "\n");
            }
            output.append(tab + "Root-Tip State Lengths:\n");
            for (state = 0; state < s.node.stateLengths.length; ++state) {
                output.append(dTab + "State " + state + ": " + s.rootTipLengths[state] + "\n");
            }
        }
        return output.toString();
    }

    public Node getTreeRoot(String treeName) {
        return this.getTree(treeName).getRoot();
    }

    private float[] getAverages() {
        float[] averages = new float[this.trees.get(0).getSpeciesList().size()];
        for (Tree tree : this.trees) {
            for (int i = 1; i < tree.getSpeciesList().size() + 1; ++i) {
                Species s = tree.getSpeciesList().get(Integer.toString(i));
                for (int length = 0; length < s.rootTipLengths.length; ++length) {
                    if (!this.selectedStates[length]) continue;
                    int n = i - 1;
                    averages[n] = averages[n] + s.rootTipLengths[length];
                }
            }
        }
        for (int i = 0; i < averages.length; ++i) {
            if (!(averages[i] > 0.0f)) continue;
            int n = i;
            averages[n] = averages[n] / (float)this.trees.size();
        }
        return averages;
    }

    public String[] getAllTreeNames() {
        String[] names = new String[this.trees.size()];
        for (int i = 0; i < this.trees.size(); ++i) {
            names[i] = this.trees.get(i).toString();
        }
        return names;
    }

    private Tree getTree(String name) {
        for (Tree tree : this.trees) {
            if (!tree.toString().equals(name)) continue;
            return tree;
        }
        return null;
    }

    public void setState(int state, boolean selected) {
        this.selectedStates[state] = selected;
    }

    public void setState(String state, boolean selected) {
        this.selectedStates[Integer.parseInt((String)state)] = selected;
    }
}

